<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v17/resources/shopping_product.proto

namespace Google\Ads\GoogleAds\V17\Resources;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A shopping product from Google Merchant Center that can be advertised by
 * campaigns.
 * The resource returns currently existing products from Google Merchant Center
 * accounts linked with the customer. A campaign includes a product by
 * specifying its merchant id (or, if available, the Multi Client Account id of
 * the merchant) in the `ShoppingSetting`, and can limit the inclusion to
 * products having a specified feed label. Standard Shopping campaigns can also
 * limit the inclusion through a `campaign_criterion.listing_scope`.
 * Queries to this resource specify a scope:
 * Account:
 *   - Filters on campaigns or ad groups are not specified.
 *   - All products from the linked Google Merchant Center accounts are
 *     returned.
 *   - Metrics and some fields (see the per-field documentation) are aggregated
 *     across all Shopping and Performance Max campaigns that include a product.
 * Campaign:
 *   - An equality filter on `campaign` is specified. Supported campaign types
 *     are Shopping, Performance Max, Demand Gen, Video.
 *   - Only products that are included by the specified campaign are returned.
 *   - Metrics and some fields (see the per-field documentation) are restricted
 *     to the specified campaign.
 * Ad group:
 *   - An equality filter on `ad group` and `campaign` is specified. Supported
 *     campaign types are Shopping, Demand Gen, Video.
 *   - Only products that are included by the specified campaign are returned.
 *   - Metrics and some fields (see the per-field documentation) are restricted
 *     to the specified ad group.
 * Note that segmentation by date segments is not permitted and will return
 * UNSUPPORTED_DATE_SEGMENTATION error. On the other hand, filtering on date
 * segments is allowed.
 *
 * Generated from protobuf message <code>google.ads.googleads.v17.resources.ShoppingProduct</code>
 */
class ShoppingProduct extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the shopping product.
     * Shopping product resource names have the form:
     * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $resource_name = '';
    /**
     * Output only. The id of the merchant that owns the product.
     *
     * Generated from protobuf field <code>int64 merchant_center_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $merchant_center_id = 0;
    /**
     * Output only. The product channel describing the locality of the product.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v17.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $channel = 0;
    /**
     * Output only. The language code as provided by the merchant, in BCP 47
     * format.
     *
     * Generated from protobuf field <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $language_code = '';
    /**
     * Output only. The product feed label as provided by the merchant.
     *
     * Generated from protobuf field <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $feed_label = '';
    /**
     * Output only. The item id of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $item_id = '';
    /**
     * Output only. The id of the Multi Client Account of the merchant, if
     * present.
     *
     * Generated from protobuf field <code>optional int64 multi_client_account_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $multi_client_account_id = null;
    /**
     * Output only. The title of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $title = null;
    /**
     * Output only. The brand of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $brand = null;
    /**
     * Output only. The price of the product in micros as provided by the
     * merchant, in the currency specified in `currency_code` (e.g. $2.97 is
     * reported as 2970000).
     *
     * Generated from protobuf field <code>optional int64 price_micros = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $price_micros = null;
    /**
     * Output only. The currency code as provided by the merchant, in ISO 4217
     * format.
     *
     * Generated from protobuf field <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $currency_code = null;
    /**
     * Output only. The channel exclusivity of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $channel_exclusivity = null;
    /**
     * Output only. The condition of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $condition = null;
    /**
     * Output only. The availability of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $availability = null;
    /**
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     *
     * Generated from protobuf field <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $target_countries;
    /**
     * Output only. The custom attribute 0 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $custom_attribute0 = null;
    /**
     * Output only. The custom attribute 1 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $custom_attribute1 = null;
    /**
     * Output only. The custom attribute 2 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $custom_attribute2 = null;
    /**
     * Output only. The custom attribute 3 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $custom_attribute3 = null;
    /**
     * Output only. The custom attribute 4 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $custom_attribute4 = null;
    /**
     * Output only. The category level 1 of the product.
     *
     * Generated from protobuf field <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $category_level1 = null;
    /**
     * Output only. The category level 2 of the product.
     *
     * Generated from protobuf field <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $category_level2 = null;
    /**
     * Output only. The category level 3 of the product.
     *
     * Generated from protobuf field <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $category_level3 = null;
    /**
     * Output only. The category level 4 of the product.
     *
     * Generated from protobuf field <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $category_level4 = null;
    /**
     * Output only. The category level 5 of the product.
     *
     * Generated from protobuf field <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $category_level5 = null;
    /**
     * Output only. The product type level 1 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $product_type_level1 = null;
    /**
     * Output only. The product type level 2 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $product_type_level2 = null;
    /**
     * Output only. The product type level 3 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $product_type_level3 = null;
    /**
     * Output only. The product type level 4 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $product_type_level4 = null;
    /**
     * Output only. The product type level 5 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $product_type_level5 = null;
    /**
     * Output only. The effective maximum cost-per-click (effective max. CPC) of
     * the product. This field is available only if the query specifies the
     * campaign or ad group scope, and if the campaign uses manual bidding. The
     * value is the highest bid set for the product in product groups across all
     * enabled ad groups. It represents the most you're willing to pay for a click
     * on the product. This field can take up to 24 hours to update.
     *
     * Generated from protobuf field <code>optional int64 effective_max_cpc_micros = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $effective_max_cpc_micros = null;
    /**
     * Output only. The status that indicates whether the product can show in ads.
     * The value of this field is restricted to the scope specified in the query,
     * see the documentation of the resource.
     * This field can take up to 24 hours to update.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v17.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $status = 0;
    /**
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v17.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $issues;
    /**
     * Output only. A campaign that includes the product.
     * This field is selectable only in the campaign scope, which requires an
     * equality filter on `campaign`.
     *
     * Generated from protobuf field <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $campaign = null;
    /**
     * Output only. An ad group of a campaign that includes the product.
     * This field is selectable only in the ad group scope, which requires an
     * equality filter on `campaign` and `ad_group`.
     *
     * Generated from protobuf field <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $ad_group = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $resource_name
     *           Output only. The resource name of the shopping product.
     *           Shopping product resource names have the form:
     *           `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
     *     @type int|string $merchant_center_id
     *           Output only. The id of the merchant that owns the product.
     *     @type int $channel
     *           Output only. The product channel describing the locality of the product.
     *     @type string $language_code
     *           Output only. The language code as provided by the merchant, in BCP 47
     *           format.
     *     @type string $feed_label
     *           Output only. The product feed label as provided by the merchant.
     *     @type string $item_id
     *           Output only. The item id of the product as provided by the merchant.
     *     @type int|string $multi_client_account_id
     *           Output only. The id of the Multi Client Account of the merchant, if
     *           present.
     *     @type string $title
     *           Output only. The title of the product as provided by the merchant.
     *     @type string $brand
     *           Output only. The brand of the product as provided by the merchant.
     *     @type int|string $price_micros
     *           Output only. The price of the product in micros as provided by the
     *           merchant, in the currency specified in `currency_code` (e.g. $2.97 is
     *           reported as 2970000).
     *     @type string $currency_code
     *           Output only. The currency code as provided by the merchant, in ISO 4217
     *           format.
     *     @type int $channel_exclusivity
     *           Output only. The channel exclusivity of the product as provided by the
     *           merchant.
     *     @type int $condition
     *           Output only. The condition of the product as provided by the merchant.
     *     @type int $availability
     *           Output only. The availability of the product as provided by the merchant.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $target_countries
     *           Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     *           product is intended to be shown in ads.
     *     @type string $custom_attribute0
     *           Output only. The custom attribute 0 of the product as provided by the
     *           merchant.
     *     @type string $custom_attribute1
     *           Output only. The custom attribute 1 of the product as provided by the
     *           merchant.
     *     @type string $custom_attribute2
     *           Output only. The custom attribute 2 of the product as provided by the
     *           merchant.
     *     @type string $custom_attribute3
     *           Output only. The custom attribute 3 of the product as provided by the
     *           merchant.
     *     @type string $custom_attribute4
     *           Output only. The custom attribute 4 of the product as provided by the
     *           merchant.
     *     @type string $category_level1
     *           Output only. The category level 1 of the product.
     *     @type string $category_level2
     *           Output only. The category level 2 of the product.
     *     @type string $category_level3
     *           Output only. The category level 3 of the product.
     *     @type string $category_level4
     *           Output only. The category level 4 of the product.
     *     @type string $category_level5
     *           Output only. The category level 5 of the product.
     *     @type string $product_type_level1
     *           Output only. The product type level 1 as provided by the merchant.
     *     @type string $product_type_level2
     *           Output only. The product type level 2 as provided by the merchant.
     *     @type string $product_type_level3
     *           Output only. The product type level 3 as provided by the merchant.
     *     @type string $product_type_level4
     *           Output only. The product type level 4 as provided by the merchant.
     *     @type string $product_type_level5
     *           Output only. The product type level 5 as provided by the merchant.
     *     @type int|string $effective_max_cpc_micros
     *           Output only. The effective maximum cost-per-click (effective max. CPC) of
     *           the product. This field is available only if the query specifies the
     *           campaign or ad group scope, and if the campaign uses manual bidding. The
     *           value is the highest bid set for the product in product groups across all
     *           enabled ad groups. It represents the most you're willing to pay for a click
     *           on the product. This field can take up to 24 hours to update.
     *     @type int $status
     *           Output only. The status that indicates whether the product can show in ads.
     *           The value of this field is restricted to the scope specified in the query,
     *           see the documentation of the resource.
     *           This field can take up to 24 hours to update.
     *     @type array<\Google\Ads\GoogleAds\V17\Resources\ShoppingProduct\ProductIssue>|\Google\Protobuf\Internal\RepeatedField $issues
     *           Output only. The list of issues affecting whether the product can show in
     *           ads. The value of this field is restricted to the scope specified in the
     *           query, see the documentation of the resource. This field can take up to 24
     *           hours to update.
     *     @type string $campaign
     *           Output only. A campaign that includes the product.
     *           This field is selectable only in the campaign scope, which requires an
     *           equality filter on `campaign`.
     *     @type string $ad_group
     *           Output only. An ad group of a campaign that includes the product.
     *           This field is selectable only in the ad group scope, which requires an
     *           equality filter on `campaign` and `ad_group`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V17\Resources\ShoppingProduct::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the shopping product.
     * Shopping product resource names have the form:
     * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * Output only. The resource name of the shopping product.
     * Shopping product resource names have the form:
     * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * Output only. The id of the merchant that owns the product.
     *
     * Generated from protobuf field <code>int64 merchant_center_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getMerchantCenterId()
    {
        return $this->merchant_center_id;
    }

    /**
     * Output only. The id of the merchant that owns the product.
     *
     * Generated from protobuf field <code>int64 merchant_center_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMerchantCenterId($var)
    {
        GPBUtil::checkInt64($var);
        $this->merchant_center_id = $var;

        return $this;
    }

    /**
     * Output only. The product channel describing the locality of the product.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v17.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * Output only. The product channel describing the locality of the product.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v17.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setChannel($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V17\Enums\ProductChannelEnum\ProductChannel::class);
        $this->channel = $var;

        return $this;
    }

    /**
     * Output only. The language code as provided by the merchant, in BCP 47
     * format.
     *
     * Generated from protobuf field <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * Output only. The language code as provided by the merchant, in BCP 47
     * format.
     *
     * Generated from protobuf field <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * Output only. The product feed label as provided by the merchant.
     *
     * Generated from protobuf field <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getFeedLabel()
    {
        return $this->feed_label;
    }

    /**
     * Output only. The product feed label as provided by the merchant.
     *
     * Generated from protobuf field <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setFeedLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->feed_label = $var;

        return $this;
    }

    /**
     * Output only. The item id of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getItemId()
    {
        return $this->item_id;
    }

    /**
     * Output only. The item id of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setItemId($var)
    {
        GPBUtil::checkString($var, True);
        $this->item_id = $var;

        return $this;
    }

    /**
     * Output only. The id of the Multi Client Account of the merchant, if
     * present.
     *
     * Generated from protobuf field <code>optional int64 multi_client_account_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getMultiClientAccountId()
    {
        return isset($this->multi_client_account_id) ? $this->multi_client_account_id : 0;
    }

    public function hasMultiClientAccountId()
    {
        return isset($this->multi_client_account_id);
    }

    public function clearMultiClientAccountId()
    {
        unset($this->multi_client_account_id);
    }

    /**
     * Output only. The id of the Multi Client Account of the merchant, if
     * present.
     *
     * Generated from protobuf field <code>optional int64 multi_client_account_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMultiClientAccountId($var)
    {
        GPBUtil::checkInt64($var);
        $this->multi_client_account_id = $var;

        return $this;
    }

    /**
     * Output only. The title of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getTitle()
    {
        return isset($this->title) ? $this->title : '';
    }

    public function hasTitle()
    {
        return isset($this->title);
    }

    public function clearTitle()
    {
        unset($this->title);
    }

    /**
     * Output only. The title of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * Output only. The brand of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getBrand()
    {
        return isset($this->brand) ? $this->brand : '';
    }

    public function hasBrand()
    {
        return isset($this->brand);
    }

    public function clearBrand()
    {
        unset($this->brand);
    }

    /**
     * Output only. The brand of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setBrand($var)
    {
        GPBUtil::checkString($var, True);
        $this->brand = $var;

        return $this;
    }

    /**
     * Output only. The price of the product in micros as provided by the
     * merchant, in the currency specified in `currency_code` (e.g. $2.97 is
     * reported as 2970000).
     *
     * Generated from protobuf field <code>optional int64 price_micros = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getPriceMicros()
    {
        return isset($this->price_micros) ? $this->price_micros : 0;
    }

    public function hasPriceMicros()
    {
        return isset($this->price_micros);
    }

    public function clearPriceMicros()
    {
        unset($this->price_micros);
    }

    /**
     * Output only. The price of the product in micros as provided by the
     * merchant, in the currency specified in `currency_code` (e.g. $2.97 is
     * reported as 2970000).
     *
     * Generated from protobuf field <code>optional int64 price_micros = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setPriceMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->price_micros = $var;

        return $this;
    }

    /**
     * Output only. The currency code as provided by the merchant, in ISO 4217
     * format.
     *
     * Generated from protobuf field <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCurrencyCode()
    {
        return isset($this->currency_code) ? $this->currency_code : '';
    }

    public function hasCurrencyCode()
    {
        return isset($this->currency_code);
    }

    public function clearCurrencyCode()
    {
        unset($this->currency_code);
    }

    /**
     * Output only. The currency code as provided by the merchant, in ISO 4217
     * format.
     *
     * Generated from protobuf field <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCurrencyCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->currency_code = $var;

        return $this;
    }

    /**
     * Output only. The channel exclusivity of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getChannelExclusivity()
    {
        return isset($this->channel_exclusivity) ? $this->channel_exclusivity : 0;
    }

    public function hasChannelExclusivity()
    {
        return isset($this->channel_exclusivity);
    }

    public function clearChannelExclusivity()
    {
        unset($this->channel_exclusivity);
    }

    /**
     * Output only. The channel exclusivity of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setChannelExclusivity($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V17\Enums\ProductChannelExclusivityEnum\ProductChannelExclusivity::class);
        $this->channel_exclusivity = $var;

        return $this;
    }

    /**
     * Output only. The condition of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getCondition()
    {
        return isset($this->condition) ? $this->condition : 0;
    }

    public function hasCondition()
    {
        return isset($this->condition);
    }

    public function clearCondition()
    {
        unset($this->condition);
    }

    /**
     * Output only. The condition of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setCondition($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V17\Enums\ProductConditionEnum\ProductCondition::class);
        $this->condition = $var;

        return $this;
    }

    /**
     * Output only. The availability of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getAvailability()
    {
        return isset($this->availability) ? $this->availability : 0;
    }

    public function hasAvailability()
    {
        return isset($this->availability);
    }

    public function clearAvailability()
    {
        unset($this->availability);
    }

    /**
     * Output only. The availability of the product as provided by the merchant.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setAvailability($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V17\Enums\ProductAvailabilityEnum\ProductAvailability::class);
        $this->availability = $var;

        return $this;
    }

    /**
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     *
     * Generated from protobuf field <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTargetCountries()
    {
        return $this->target_countries;
    }

    /**
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     *
     * Generated from protobuf field <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTargetCountries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->target_countries = $arr;

        return $this;
    }

    /**
     * Output only. The custom attribute 0 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCustomAttribute0()
    {
        return isset($this->custom_attribute0) ? $this->custom_attribute0 : '';
    }

    public function hasCustomAttribute0()
    {
        return isset($this->custom_attribute0);
    }

    public function clearCustomAttribute0()
    {
        unset($this->custom_attribute0);
    }

    /**
     * Output only. The custom attribute 0 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomAttribute0($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_attribute0 = $var;

        return $this;
    }

    /**
     * Output only. The custom attribute 1 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCustomAttribute1()
    {
        return isset($this->custom_attribute1) ? $this->custom_attribute1 : '';
    }

    public function hasCustomAttribute1()
    {
        return isset($this->custom_attribute1);
    }

    public function clearCustomAttribute1()
    {
        unset($this->custom_attribute1);
    }

    /**
     * Output only. The custom attribute 1 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomAttribute1($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_attribute1 = $var;

        return $this;
    }

    /**
     * Output only. The custom attribute 2 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCustomAttribute2()
    {
        return isset($this->custom_attribute2) ? $this->custom_attribute2 : '';
    }

    public function hasCustomAttribute2()
    {
        return isset($this->custom_attribute2);
    }

    public function clearCustomAttribute2()
    {
        unset($this->custom_attribute2);
    }

    /**
     * Output only. The custom attribute 2 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomAttribute2($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_attribute2 = $var;

        return $this;
    }

    /**
     * Output only. The custom attribute 3 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCustomAttribute3()
    {
        return isset($this->custom_attribute3) ? $this->custom_attribute3 : '';
    }

    public function hasCustomAttribute3()
    {
        return isset($this->custom_attribute3);
    }

    public function clearCustomAttribute3()
    {
        unset($this->custom_attribute3);
    }

    /**
     * Output only. The custom attribute 3 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomAttribute3($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_attribute3 = $var;

        return $this;
    }

    /**
     * Output only. The custom attribute 4 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCustomAttribute4()
    {
        return isset($this->custom_attribute4) ? $this->custom_attribute4 : '';
    }

    public function hasCustomAttribute4()
    {
        return isset($this->custom_attribute4);
    }

    public function clearCustomAttribute4()
    {
        unset($this->custom_attribute4);
    }

    /**
     * Output only. The custom attribute 4 of the product as provided by the
     * merchant.
     *
     * Generated from protobuf field <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomAttribute4($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_attribute4 = $var;

        return $this;
    }

    /**
     * Output only. The category level 1 of the product.
     *
     * Generated from protobuf field <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCategoryLevel1()
    {
        return isset($this->category_level1) ? $this->category_level1 : '';
    }

    public function hasCategoryLevel1()
    {
        return isset($this->category_level1);
    }

    public function clearCategoryLevel1()
    {
        unset($this->category_level1);
    }

    /**
     * Output only. The category level 1 of the product.
     *
     * Generated from protobuf field <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryLevel1($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_level1 = $var;

        return $this;
    }

    /**
     * Output only. The category level 2 of the product.
     *
     * Generated from protobuf field <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCategoryLevel2()
    {
        return isset($this->category_level2) ? $this->category_level2 : '';
    }

    public function hasCategoryLevel2()
    {
        return isset($this->category_level2);
    }

    public function clearCategoryLevel2()
    {
        unset($this->category_level2);
    }

    /**
     * Output only. The category level 2 of the product.
     *
     * Generated from protobuf field <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryLevel2($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_level2 = $var;

        return $this;
    }

    /**
     * Output only. The category level 3 of the product.
     *
     * Generated from protobuf field <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCategoryLevel3()
    {
        return isset($this->category_level3) ? $this->category_level3 : '';
    }

    public function hasCategoryLevel3()
    {
        return isset($this->category_level3);
    }

    public function clearCategoryLevel3()
    {
        unset($this->category_level3);
    }

    /**
     * Output only. The category level 3 of the product.
     *
     * Generated from protobuf field <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryLevel3($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_level3 = $var;

        return $this;
    }

    /**
     * Output only. The category level 4 of the product.
     *
     * Generated from protobuf field <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCategoryLevel4()
    {
        return isset($this->category_level4) ? $this->category_level4 : '';
    }

    public function hasCategoryLevel4()
    {
        return isset($this->category_level4);
    }

    public function clearCategoryLevel4()
    {
        unset($this->category_level4);
    }

    /**
     * Output only. The category level 4 of the product.
     *
     * Generated from protobuf field <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryLevel4($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_level4 = $var;

        return $this;
    }

    /**
     * Output only. The category level 5 of the product.
     *
     * Generated from protobuf field <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCategoryLevel5()
    {
        return isset($this->category_level5) ? $this->category_level5 : '';
    }

    public function hasCategoryLevel5()
    {
        return isset($this->category_level5);
    }

    public function clearCategoryLevel5()
    {
        unset($this->category_level5);
    }

    /**
     * Output only. The category level 5 of the product.
     *
     * Generated from protobuf field <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryLevel5($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_level5 = $var;

        return $this;
    }

    /**
     * Output only. The product type level 1 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProductTypeLevel1()
    {
        return isset($this->product_type_level1) ? $this->product_type_level1 : '';
    }

    public function hasProductTypeLevel1()
    {
        return isset($this->product_type_level1);
    }

    public function clearProductTypeLevel1()
    {
        unset($this->product_type_level1);
    }

    /**
     * Output only. The product type level 1 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeLevel1($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_level1 = $var;

        return $this;
    }

    /**
     * Output only. The product type level 2 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProductTypeLevel2()
    {
        return isset($this->product_type_level2) ? $this->product_type_level2 : '';
    }

    public function hasProductTypeLevel2()
    {
        return isset($this->product_type_level2);
    }

    public function clearProductTypeLevel2()
    {
        unset($this->product_type_level2);
    }

    /**
     * Output only. The product type level 2 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeLevel2($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_level2 = $var;

        return $this;
    }

    /**
     * Output only. The product type level 3 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProductTypeLevel3()
    {
        return isset($this->product_type_level3) ? $this->product_type_level3 : '';
    }

    public function hasProductTypeLevel3()
    {
        return isset($this->product_type_level3);
    }

    public function clearProductTypeLevel3()
    {
        unset($this->product_type_level3);
    }

    /**
     * Output only. The product type level 3 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeLevel3($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_level3 = $var;

        return $this;
    }

    /**
     * Output only. The product type level 4 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProductTypeLevel4()
    {
        return isset($this->product_type_level4) ? $this->product_type_level4 : '';
    }

    public function hasProductTypeLevel4()
    {
        return isset($this->product_type_level4);
    }

    public function clearProductTypeLevel4()
    {
        unset($this->product_type_level4);
    }

    /**
     * Output only. The product type level 4 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeLevel4($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_level4 = $var;

        return $this;
    }

    /**
     * Output only. The product type level 5 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProductTypeLevel5()
    {
        return isset($this->product_type_level5) ? $this->product_type_level5 : '';
    }

    public function hasProductTypeLevel5()
    {
        return isset($this->product_type_level5);
    }

    public function clearProductTypeLevel5()
    {
        unset($this->product_type_level5);
    }

    /**
     * Output only. The product type level 5 as provided by the merchant.
     *
     * Generated from protobuf field <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeLevel5($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_level5 = $var;

        return $this;
    }

    /**
     * Output only. The effective maximum cost-per-click (effective max. CPC) of
     * the product. This field is available only if the query specifies the
     * campaign or ad group scope, and if the campaign uses manual bidding. The
     * value is the highest bid set for the product in product groups across all
     * enabled ad groups. It represents the most you're willing to pay for a click
     * on the product. This field can take up to 24 hours to update.
     *
     * Generated from protobuf field <code>optional int64 effective_max_cpc_micros = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getEffectiveMaxCpcMicros()
    {
        return isset($this->effective_max_cpc_micros) ? $this->effective_max_cpc_micros : 0;
    }

    public function hasEffectiveMaxCpcMicros()
    {
        return isset($this->effective_max_cpc_micros);
    }

    public function clearEffectiveMaxCpcMicros()
    {
        unset($this->effective_max_cpc_micros);
    }

    /**
     * Output only. The effective maximum cost-per-click (effective max. CPC) of
     * the product. This field is available only if the query specifies the
     * campaign or ad group scope, and if the campaign uses manual bidding. The
     * value is the highest bid set for the product in product groups across all
     * enabled ad groups. It represents the most you're willing to pay for a click
     * on the product. This field can take up to 24 hours to update.
     *
     * Generated from protobuf field <code>optional int64 effective_max_cpc_micros = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setEffectiveMaxCpcMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->effective_max_cpc_micros = $var;

        return $this;
    }

    /**
     * Output only. The status that indicates whether the product can show in ads.
     * The value of this field is restricted to the scope specified in the query,
     * see the documentation of the resource.
     * This field can take up to 24 hours to update.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v17.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Output only. The status that indicates whether the product can show in ads.
     * The value of this field is restricted to the scope specified in the query,
     * see the documentation of the resource.
     * This field can take up to 24 hours to update.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v17.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V17\Enums\ProductStatusEnum\ProductStatus::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v17.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIssues()
    {
        return $this->issues;
    }

    /**
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v17.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Ads\GoogleAds\V17\Resources\ShoppingProduct\ProductIssue>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIssues($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\GoogleAds\V17\Resources\ShoppingProduct\ProductIssue::class);
        $this->issues = $arr;

        return $this;
    }

    /**
     * Output only. A campaign that includes the product.
     * This field is selectable only in the campaign scope, which requires an
     * equality filter on `campaign`.
     *
     * Generated from protobuf field <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCampaign()
    {
        return isset($this->campaign) ? $this->campaign : '';
    }

    public function hasCampaign()
    {
        return isset($this->campaign);
    }

    public function clearCampaign()
    {
        unset($this->campaign);
    }

    /**
     * Output only. A campaign that includes the product.
     * This field is selectable only in the campaign scope, which requires an
     * equality filter on `campaign`.
     *
     * Generated from protobuf field <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCampaign($var)
    {
        GPBUtil::checkString($var, True);
        $this->campaign = $var;

        return $this;
    }

    /**
     * Output only. An ad group of a campaign that includes the product.
     * This field is selectable only in the ad group scope, which requires an
     * equality filter on `campaign` and `ad_group`.
     *
     * Generated from protobuf field <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAdGroup()
    {
        return isset($this->ad_group) ? $this->ad_group : '';
    }

    public function hasAdGroup()
    {
        return isset($this->ad_group);
    }

    public function clearAdGroup()
    {
        unset($this->ad_group);
    }

    /**
     * Output only. An ad group of a campaign that includes the product.
     * This field is selectable only in the ad group scope, which requires an
     * equality filter on `campaign` and `ad_group`.
     *
     * Generated from protobuf field <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAdGroup($var)
    {
        GPBUtil::checkString($var, True);
        $this->ad_group = $var;

        return $this;
    }

}

