<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - Download Your Bundle</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
        }

        .container {
            background: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            width: 90%;
            margin: 20px auto;
            text-align: left;
        }

        .title {
            font-size: 22px;
            font-weight: bold;
            color: #28a745;
            text-align: center;
            margin: 15px 0;
        }

        .sub_title {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            text-align: center;
            margin: 15px 0;
        }

        .message {
            font-size: 16px;
            color: #333;
            margin: 15px 0;
            line-height: 1.5;
        }

        .download-section {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            font-size: 14px;
            line-height: 1.5;
            text-align: center;
        }

        .download-button {
            display: block;
            background: #007bff;
            color: #fff;
            padding: 12px 15px;
            text-decoration: none;
            font-size: 16px;
            border-radius: 5px;
            text-align: center;
            margin: 10px auto;
            width: 80%;
        }

        .highlight-button {
            background: #E91E63;
            font-size: 18px;
            font-weight: bold;
            padding: 14px 20px;
            border-radius: 8px;
            box-shadow: 0px 4px 8px rgba(255, 152, 0, 0.4);
            transition: all 0.3s ease-in-out;
        }

        .highlight-button:hover {
            background: #E91E63;
            box-shadow: 0px 6px 12px rgba(255, 152, 0, 0.6);
        }

        .order-summary {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            font-size: 14px;
            line-height: 1.5;
        }

        .order-summary p {
            margin: 5px 0;
        }

        .footer {
            margin-top: 20px;
            font-size: 13px;
            color: #777;
            text-align: center;
        }

        /* Responsive Design */
        @media screen and (max-width: 480px) {
            .container {
                padding: 15px;
                width: 95%;
            }

            .title {
                font-size: 20px;
            }

            .sub_title {
                font-size: 16px;
            }

            .message {
                font-size: 15px;
                margin: 10px 0;
            }

            .download-button {
                font-size: 14px;
                padding: 10px 12px;
            }

            .footer {
                font-size: 12px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="title">✅ Your Purchase Was Successful!</div>
        <div class="sub_title"><?php echo e($product_name); ?></div>

        <p class="message">Hi <strong><?php echo e($user_name); ?></strong>,</p>
        <p class="message">
            Thank you for your purchase! 🎉 You now have access to your exclusive bundles. Click the buttons below to
            download your content instantly.
        </p>

        <div class="download-section">
            <h3>📥 Download Your Files:</h3>
            <a href="<?php echo e($download_bundle); ?>" class="download-button highlight-button">🚀 Download Buddha Stories
                Bundle</a>
            <a href="<?php echo e($free_bonus_1); ?>" class="download-button">Download 5+ Bonuses</a>
            <a href="<?php echo e($all_links_pdf); ?>" class="download-button">Download All Links PDF</a>
        </div>

        <div class="order-summary">
            <h3>📦 Order Summary:</h3>
            <p><strong>Transaction ID:</strong> <?php echo e($txn_id); ?></p>
            <p><strong>Transaction Date:</strong> <?php echo e($txn_date); ?></p>
            <p><strong>Transaction Amount:</strong> ₹<?php echo e($price); ?></p>
            <p><strong>Customer Details:</strong> <?php echo e($user_email); ?> | <?php echo e($user_mobile); ?></p>
        </div>

        <p class="footer">If you have any issues accessing your files, feel free to contact us.</p>
    </div>
</body>

</html>
<?php /**PATH /home/shyambabamatka/public_html/startdigital.site/resources/views/buddha-bundle/paymentSuccessMail.blade.php ENDPATH**/ ?>