<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Successful Transactions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }

        td {
            white-space: nowrap;
        }

        .container {
            margin-top: 50px;
        }

        h2 {
            text-align: center;
            margin-bottom: 30px;
        }

        .table {
            background-color: #fff;
        }

        .thead-dark th {
            background-color: #343a40;
            color: white;
        }

        .table-hover tbody tr:hover {
            background-color: #f1f1f1;
        }

        /* Simple Pagination Styles */
        .simple-pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 20px;
        }

        .simple-pagination .page-link {
            color: #343a40;
            border: 1px solid #dee2e6;
            padding: 8px 16px;
            border-radius: 4px;
            background-color: white;
            transition: all 0.3s ease;
            margin: 0 5px;
        }

        .simple-pagination .page-link:hover {
            background-color: #f8f9fa;
            border-color: #343a40;
        }

        .simple-pagination .page-item.disabled .page-link {
            color: #6c757d;
            pointer-events: none;
            background-color: #f8f9fa;
            border-color: #dee2e6;
        }

        .simple-pagination .page-info {
            margin: 0 10px;
            font-size: 16px;
        }
    </style>
</head>

<body>
    <div class="container">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <h2>Transactions</h2>

        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th>#</th>
                        <th>Website</th>
                        <th>Product</th>
                        <th>Platform</th>
                        <th>Name</th>
                        <th>User Email</th>
                        <th>User Mobile</th>
                        <th>Date & Time</th>
                        <th>Status</th>
                        <th>1st Mail</th>
                        <th>2nd Mail</th>
                        <th>1st WA</th>
                        <th>2nd WA</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($transactions as $index => $transaction)
                        <tr>
                            <td>{{ $transaction->id }}</td>
                            <td>{{ $transaction->website }}</td>
                            <td>{{ $transaction->product_key }}</td>
                            <td>{{ $transaction->platform }}</td>
                            <td>{{ $transaction->user_name }}</td>
                            <td>{{ $transaction->user_email }}</td>
                            <td>{{ $transaction->user_mobile }}</td>
                            <td>{{ $transaction->created_at?->format('d M Y, h:i A') }}</td>
                            <td>
                                <strong
                                    class="{{ $transaction->status == 'success' ? 'text-primary' : 'text-danger' }}">
                                    {{ strtoupper($transaction->status) }}
                                </strong>
                            </td>
                            <td>{{ optional($transaction->first_email_sent_at)->format('h:i') }}</td>
                            <td>{{ optional($transaction->second_email_sent_at)->format('h:i') }}</td>
                            <td>{{ optional($transaction->first_whatsapp_sent_at)->format('h:i') }}</td>
                            <td>{{ optional($transaction->second_whatsapp_sent_at)->format('h:i') }}</td>
                            <td>
                                @if ($transaction->status !== 'success')
                                    <a href="{{ url('mark-success/' . $transaction->id) }}"
                                        class="btn btn-success btn-sm">
                                        Approve
                                    </a>
                                @else
                                    <span class="text-muted">Approved</span>
                                @endif
                                @if ($transaction->status == 'success')
                                    <a href="{{ url('mark-success/' . $transaction->id) }}"
                                        class="btn btn-success btn-sm">
                                        Notify Platform
                                    </a>
                                @endif
                            </td>

                        </tr>
                    @empty
                        <tr>
                            <td colspan="13" class="text-center">No Transactions Found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Simple Pagination -->
        <div class="simple-pagination">
            {{-- Previous Button --}}
            @if ($transactions->onFirstPage())
                <span class="page-link disabled">&laquo; Previous</span>
            @else
                <a href="{{ $transactions->previousPageUrl() }}" class="page-link">&laquo; Previous</a>
            @endif

            {{-- Current Page and Total Pages --}}
            <span class="page-info">
                Page {{ $transactions->currentPage() }} of {{ $transactions->lastPage() }}
            </span>

            {{-- Next Button --}}
            @if ($transactions->hasMorePages())
                <a href="{{ $transactions->nextPageUrl() }}" class="page-link">Next &raquo;</a>
            @else
                <span class="page-link disabled">Next &raquo;</span>
            @endif
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
