<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Refund & Cancellations</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            color: #333;
        }

        .container {
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        h1 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }

        p {
            margin-bottom: 15px;
            text-align: justify;
        }

        .highlight {
            color: #007BFF;
            font-weight: bold;
        }

        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 0.9em;
            color: #777;
        }

        .footer a {
            color: #007BFF;
            text-decoration: none;
        }

        .footer a:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>Refund & Cancellations</h1>
        <p>At <span class="highlight">StartDigital</span>, we take pride in delivering high-quality digital products to
            help you grow your online presence. Due to the nature of our products, we do not offer refunds or
            cancellations once a purchase has been made.</p>

        <p>All sales are final. As our products are digital in nature and instantly accessible upon purchase, we cannot
            accept returns, exchanges, or provide refunds. We encourage our customers to review product details
            carefully before making a purchase.</p>

        <p>If you experience any issues with your purchase, such as download problems or file corruption, please reach
            out to our support team at <a
                href="mailto:{{ env('MAIL_FROM_ADDRESS') }}">{{ env('MAIL_FROM_ADDRESS') }}</a>,
            and we
            will be happy to assist you in resolving the issue.</p>

        <p>By making a purchase on our website, you acknowledge and agree to our no-refund and no-cancellation policy.
        </p>

        <div class="footer">
            <p>&copy; 2025 StartDigital. All rights reserved.</p>
            <p><a href="/terms-and-conditions">Terms & Conditions</a> | <a href="/privacy-policy">Privacy Policy</a> | <a
                    href="/contact-us">Contact Us</a></p>
        </div>
    </div>
</body>

</html>
