@extends('layouts.master')

@section('content')
    <div class="payment-wrp">
        <div class="container" style="width:unset;">
            <div class="payment-form">
                <h2>Payment Successful 🎉</h2>
                <p>Your payment has been received successfully, and your file is ready to be downloaded.</p>
                <img src="{{ asset('assets/insta-reels/images/green-check.png') }}" class="success-icon" alt="Success">

                <button style="background: rgb(128, 52, 133);" class="download-btn"
                    onclick="window.location.href='/open-mail-free/{{ $product['key'] }}'">
                    Open File Now
                </button>

                <button class="download-btn mt-3" onclick="window.location.href='/download/{{ $txn_id }}'">
                    Download File <i class="fas fa-download"></i>
                </button>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <link href="https://fonts.googleapis.com/css2?family=Hind+Madurai:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Inter', sans-serif;
        }

        .payment-wrp {
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .payment-form {
            background: #fff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 500px;
            width: 100%;
        }

        .payment-form h2 {
            font-size: 26px;
            font-weight: 700;
            color: #28a745;
            margin-bottom: 10px;
        }

        .payment-form p {
            font-size: 16px;
            color: #6c757d;
            margin-bottom: 20px;
        }

        .success-icon {
            width: 100px;
            margin: 20px 0;
            animation: bounce 1s ease-in-out infinite alternate;
        }

        @keyframes bounce {
            from {
                transform: translateY(0);
            }

            to {
                transform: translateY(-10px);
            }
        }

        .download-btn {
            display: inline-block;
            width: 100%;
            background: linear-gradient(135deg, #28a745, #218838);
            color: #fff;
            font-size: 18px;
            font-weight: 600;
            padding: 14px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: 0.3s;
            text-transform: uppercase;
            box-shadow: 0 4px 10px rgba(40, 167, 69, 0.3);
        }

        .download-btn:hover {
            background: linear-gradient(135deg, #218838, #1e7e34);
            transform: scale(1.05);
            box-shadow: 0 6px 15px rgba(40, 167, 69, 0.4);
        }

        .download-btn i {
            margin-left: 8px;
        }
    </style>
@endpush

@push('scripts')
    <!-- Scripts -->
    <script>
        if (!localStorage.getItem('fbqPurchaseTracked')) {
            let whichPlatform = '{{ $transactino_check->platform }}';

            if (whichPlatform == 'google') {
                gtag('event', 'conversion', {
                    'send_to': "{{ $product['google_purchase_event_id'] }}",
                    'value': "{{ $product['price'] }}",
                    'currency': 'INR',
                    'transaction_id': "{{ $txn_id }}"
                });
            } else if (whichPlatform == 'meta') {
                //keep only server side events
                fbq('track', 'Purchase', {
                    value: "{{ $product['price'] }}",
                    currency: 'INR',
                    eventID: "{{ $txn_id }}"
                });
            }

            localStorage.setItem('fbqPurchaseTracked', 'true');
        }
    </script>
    <script src="{{ asset('assets/js/jquery.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap.bundle.min.js') }}"></script>
@endpush
