<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Cancelled</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
        }

        .container {
            background: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 500px;
            width: 90%;
            margin: 20px auto;
            text-align: left;
        }

        .header img {
            width: 100%;
            border-radius: 10px 10px 0 0;
        }

        .title {
            font-size: 22px;
            font-weight: bold;
            color: #d9534f;
            text-align: center;
            margin: 15px 0;
        }

        .message {
            font-size: 16px;
            color: #333;
            margin: 15px 0;
            line-height: 1.5;
        }

        .order-details {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            font-size: 14px;
            line-height: 1.5;
        }

        .order-details p {
            margin: 5px 0;
        }

        .order-details strong {
            color: #333;
        }

        .button {
            display: block;
            background: #28a745;
            color: #fff;
            padding: 12px 15px;
            text-decoration: none;
            font-size: 16px;
            border-radius: 5px;
            text-align: center;
            margin: 20px auto;
            width: 180px;
        }

        .unsubscribe {
            display: block;
            background: #dc3545;
            color: #fff;
            padding: 10px 15px;
            text-decoration: none;
            font-size: 14px;
            border-radius: 5px;
            text-align: center;
            margin: 15px auto;
            width: 160px;
        }

        .footer {
            margin-top: 20px;
            font-size: 13px;
            color: #777;
            text-align: center;
        }

        /* Responsive Design */
        @media screen and (max-width: 480px) {
            .container {
                padding: 15px;
                width: 95%;
            }

            .title {
                font-size: 20px;
            }

            .message {
                font-size: 15px;
                margin: 10px 0;
            }

            .order-details {
                font-size: 13px;
                padding: 12px;
            }

            .button {
                font-size: 14px;
                padding: 10px 12px;
                width: 160px;
            }

            .unsubscribe {
                font-size: 13px;
                padding: 8px 12px;
                width: 150px;
            }

            .footer {
                font-size: 12px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="title">Wooah!!! 😢 Your Order Has Been Cancelled! ❌❌</div>

        <p class="message">Hi <strong>{{ $user_name }}</strong>,</p>
        <p class="message">
            We’re sorry, but your order for <strong>{{ $name }}</strong> has been <span
                style="color: red;"><strong>cancelled</strong></span>.
        </p>

        <div class="order-details">
            <h3>📦 Order Details:</h3>
            <p><strong>Order ID:</strong> {{ $txn_id }}</p>
            <p><strong>Phone:</strong> {{ $user_mobile }}</p>
            <p><strong>Email:</strong> {{ $user_email }}</p>
            <p><strong>Total Amount:</strong> ₹{{ $price }}</p>
        </div>

        <p class="message">We apologize for this inconvenience. If you have any questions, please contact us.</p>

        <!-- Reorder Button -->
        <a href="{{ $reorder_url }}" class="button">Reorder Now</a>

        <!-- Header Image -->
        <div class="header">
            <img src="{{ $domain }}/public/assets/images/order.png" alt="reels_bundle">
        </div>

        <p class="footer">If you have already purchased and received the product, please ignore this message.</p>

        <!-- Unsubscribe Button -->
        <a href="{{ $unsubscribe_url }}" class="unsubscribe">Unsubscribe</a>

    </div>
</body>

</html>
