<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Favicon & Title -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('logo.png') }}" />
    <title>{{ isset($product['meta_title']) ? $product['meta_title'] : env('META_TITLE') }}</title>
    <meta name="description" content="{{ isset($product['meta_description']) ? $product['meta_description'] : '' }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/buddha-bundle/css/style.css') }}">
    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" />
    <!-- Meta Pixel Code -->
    <script>
        ! function(f, b, e, v, n, t, s) {
            if (f.fbq) return;
            n = f.fbq = function() {
                n.callMethod ?
                    n.callMethod.apply(n, arguments) : n.queue.push(arguments)
            };
            if (!f._fbq) f._fbq = n;
            n.push = n;
            n.loaded = !0;
            n.version = '2.0';
            n.queue = [];
            t = b.createElement(e);
            t.async = !0;
            t.src = v;
            s = b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t, s)
        }(window, document, 'script',
            'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '{{ isset($product['pixel_id']) ? $product['pixel_id'] : '' }}');
        fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id={{ isset($product['pixel_id']) ? $product['pixel_id'] : '' }}&ev=PageView&noscript=1" /></noscript>
    <!-- End Meta Pixel Code -->

    <!-- Google tag (gtag.js) -->
    <script async
        src="https://www.googletagmanager.com/gtag/js?id={{ isset($product['google_aw_id']) ? $product['google_aw_id'] : '' }}">
    </script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', "{{ isset($product['google_aw_id']) ? $product['google_aw_id'] : '' }}");
    </script>

    <!-- Page Specific Styles -->
    @stack('styles')
</head>

<body>
    <!-- Page Content -->
    @yield('content')

    <!-- Page Specific Scripts -->
    @stack('scripts')
</body>

</html>
