@extends('buddha-bundle.master')

@section('meta_title', $product['meta_title'])
@section('meta_description', $product['meta_description'])

@section('content')
    <div class="header">
        <div class="wrapper">
            <div class="headerInner">
                <div style="max-width: 45px;" class="siteLogo">
                    <img src="{{ asset('circle_logo.png') }}" alt="">
                </div>
            </div>
        </div>
    </div>
    <div class="limitedOfferSec">
        <div class="wrapper">
            <div class="limitedOffer">
                <h2 class="mainTitle">⏱️ Limited Period Offer⏱️</h2>
                <h2 class="secondTitle">"YouTube पर बुद्धा स्टोरी के वीडियो अपलोड करके पैसे कमाएँ!"</h2>
                <div class="offerDetails">
                    <div class="odLeft">
                        <img src="{{ asset('assets/buddha-bundle/images/odLet.webp') }}" alt="">
                    </div>
                    <div class="odRight">
                        <img src="{{ asset('assets/buddha-bundle/images/order.webp') }}" alt="">
                    </div>
                </div>
            </div>
            <div class="limitedBuy">
                <div class="lbLeft">
                    <a href="/payment/{{ $product['key'] }}" class="buyButton" id="buyNowButton">BUY
                        NOW @ {{ $product['price'] }}</a>
                </div>
                <div class="lbRight">
                    <img src="{{ asset('assets/buddha-bundle/images/20250201_0145581-1536x300.webp') }}" alt="">
                </div>
            </div>
            <div class="offerTimer">
                <div class="otLeft">
                    <h2>
                        ✅ No Copyright Issues 🎯🚀<br>
                        ✅ 4K HD Quality 📺✨<br>
                        ✅ No Logo 🚫🔖<br>
                        ✅ No Watermark ❌💦<br>
                        ✅ One-Time Fee 💰✅<br>
                        ✅ Lifetime Access 🔓♾<br>
                        ✅ Instant Download&nbsp;File&nbsp;⚡📂
                    </h2>
                </div>
                <div class="otRight">
                    <div class="otrItem">
                        <span class="big" id="hours">22</span>
                        <span class="small">Hours</span>
                    </div>
                    <div class="otrItem">
                        <span class="big" id="minutes">31</span>
                        <span class="small">Minutes</span>
                    </div>
                    <div class="otrItem">
                        <span class="big" id="seconds">17</span>
                        <span class="small">Seconds</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="aboutSec">
        <div class="wrapper">
            <div class="aboutInner">
                <h2 class="siteTitle">
                    About These Bundle
                </h2>
                <div class="aboutVideo">
                    <video class="elementor-video"
                        src="https://budhakamaibox.shop/wp-content/uploads/2025/02/buddha-bundle-ad-copy.mp4" controls=""
                        preload="metadata" controlslist="nodownload"></video>
                </div>
            </div>
        </div>
    </div>
    <div class="sampleSec">
        <div class="wrapper">
            <div class="sampleInner">
                <h2 class="siteTitle">Sample</h2>
                <div class="firstSample">
                    <div class="fsItem">
                        <img src="{{ asset('assets/buddha-bundle/images/20250131_143904-1536x1140.webp') }}" alt="">
                    </div>
                    <div class="fsItem">
                        <img src="{{ asset('assets/buddha-bundle/images/20250131_143826-2048x1520.webp') }}" alt="">
                    </div>
                    <div class="fsItem">
                        <img src="{{ asset('assets/buddha-bundle/images/20250131_143746-2048x1520.webp') }}" alt="">
                    </div>
                </div>
                <div class="youtubeSample sampleSecInner">
                    <div class="ysItem">
                        <iframe width="352" height="198" src="https://www.youtube.com/embed/sI0E-f_NE2A?start=49"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                            allowfullscreen aria-hidden="false">
                        </iframe>
                    </div>
                    <div class="ysItem">
                        <iframe width="352" height="198" src="https://www.youtube.com/embed/HyCNgcY7N0k"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                            allowfullscreen aria-hidden="false">
                        </iframe>

                    </div>
                    <div class="ysItem">
                        <iframe width="352" height="198" src="https://www.youtube.com/embed/20Be-jeM7jo"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                            allowfullscreen aria-hidden="false">
                        </iframe>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="freeBonus">
        <div class="wrapper">
            <div class="freeBonusInner">
                <h2 class="siteTitle">
                    Free Bonus
                </h2>
                <div class="freeBonusContainer">
                    <div class="fbItem">
                        <img src="{{ asset('assets/buddha-bundle/images/Picsart_25-01-28_15-46-13-860-1-1536x1536.webp') }}"
                            alt="">
                    </div>
                    <div class="fbItem">
                        <img src="{{ asset('assets/buddha-bundle/images/Picsart_25-01-28_15-46-47-970-1-1536x1536.webp') }}"
                            alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="bonusSample">
        <div class="wrapper">
            <div class="bsInner">
                <h2 class="siteTitle">Free bonus sample</h2>
                <div class="youtubeSample">
                    <div class="ysItem">
                        <iframe width="354" height="354" src="https://www.youtube.com/embed/7_jqRLckQNc"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                            allowfullscreen aria-hidden="false">
                        </iframe>
                    </div>
                    <div class="ysItem">
                        <iframe width="354" height="354" src="https://www.youtube.com/embed/igLMZUu1bQ0"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                            allowfullscreen aria-hidden="false">
                        </iframe>
                    </div>
                    <div class="ysItem">
                        <iframe width="354" height="354" src="https://www.youtube.com/embed/3h2m7vVum_U"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                            allowfullscreen aria-hidden="false">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="buyContainer">
        <div class="wrapper">
            <div class="bcInner">
                <a href="/payment/{{ $product['key'] }}" class="buyButton" id="buyNowButton">BUY
                    NOW @ {{ $product['price'] }}</a>
            </div>
        </div>
    </div>
    <div class="freeBonus earningProof">
        <div class="wrapper">
            <div class="freeBonusInner">
                <h2 class="siteTitle">
                    Earnings Proof
                </h2>
                <div class="freeBonusContainer">
                    <div class="fbItem">
                        <img src="{{ asset('assets/buddha-bundle/images/20250123_005153-1536x1536.webp') }}"
                            alt="">
                    </div>
                    <div class="fbItem">
                        <img src="{{ asset('assets/buddha-bundle/images/20250123_004703-1536x1536.webp') }}"
                            alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="customerReviewSec">
        <div class="wrapper">
            <div class="crInner">
                <h2 class="siteTitle">customer review</h2>
                <div class="crContainer">
                    <div class="crItem">
                        <img src="{{ asset('assets/buddha-bundle/images/20250203_181404-1536x1536.webp') }}"
                            alt="">
                    </div>
                    <div class="crItem">
                        <img src="{{ asset('assets/buddha-bundle/images/20250203_181958-1536x1536.webp') }}"
                            alt="">
                    </div>
                    <div class="crItem">
                        <img src="{{ asset('assets/buddha-bundle/images/20250203_182223-1536x1536.webp') }}"
                            alt="">
                    </div>
                    <div class="crItem">
                        <img src="{{ asset('assets/buddha-bundle/images/20250203_181717-1536x1536.webp') }}"
                            alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="buyContainer">
        <div class="wrapper">
            <div class="bcInner">
                <a href="/payment/{{ $product['key'] }}" class="buyButton" id="buyNowButton">BUY
                    NOW @ {{ $product['price'] }}</a>
            </div>
        </div>
    </div>
    <div class="thankYou">
        <div class="wrapper">
            <div class="tyInner">
                <h2>❤️Thank you❤️</h2>
            </div>
        </div>
    </div>
    <div class="footer">
        <div class="wrapper">
            <div class="footerInner">
                <p>© [2025] {{ $product['product_name'] }}. All rights reserved.</p>
            </div>
        </div>
    </div>
    <div class="scrollToTop">
        <button id="scrollToTopBtn">
            <svg class="ast-arrow-svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                version="1.1" x="0px" y="0px" width="26px" height="16.043px" viewBox="57 35.171 26 16.043"
                enable-background="new 57 35.171 26 16.043" xml:space="preserve">
                <path d="M57.5,38.193l12.5,12.5l12.5-12.5l-2.5-2.5l-10,10l-10-10L57.5,38.193z"></path>
            </svg>
        </button>
    </div>
@endsection

@push('styles')
@endpush

@push('scripts')
    <script>
        const scrollToTopBtn = document.getElementById("scrollToTopBtn");

        window.onscroll = function() {
            if (document.body.scrollTop > 300 || document.documentElement.scrollTop > 300) {
                scrollToTopBtn.style.display = "block";
            } else {
                scrollToTopBtn.style.display = "none";
            }
        };
        scrollToTopBtn.addEventListener("click", function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });



        function startCountdown(targetDateString) {
            let parts = targetDateString.split(" ");
            let dateParts = parts[0].split("-");
            let timeParts = parts[1].split(":");

            let targetTime = new Date(
                dateParts[2],
                dateParts[1] - 1,
                dateParts[0],
                timeParts[0],
                timeParts[1],
                0,
                0
            );

            if (targetTime <= new Date()) {
                targetTime.setDate(targetTime.getDate() + 1);
            }

            let interval = setInterval(function() {
                let now = new Date().getTime();
                let timeRemaining = targetTime - now;

                if (timeRemaining <= 0) {
                    clearInterval(interval);
                    console.log("Countdown complete!");
                    return;
                }

                let hours = Math.floor(timeRemaining / (1000 * 60 * 60));
                let minutes = Math.floor((timeRemaining % (1000 * 60 * 60)) / (1000 * 60));
                let seconds = Math.floor((timeRemaining % (1000 * 60)) / 1000);


                document.getElementById('hours').textContent = formatTime(hours);
                document.getElementById('minutes').textContent = formatTime(minutes);
                document.getElementById('seconds').textContent = formatTime(seconds);
            }, 1000);
        }

        function formatTime(time) {
            return time < 10 ? "0" + time : time;
        }

        startCountdown("03-03-2025 15:59");
    </script>
    <script>
        document.getElementById('buyNowButton').addEventListener('click', function() {
            fbq('track', 'InitiateCheckout');
        });
    </script>
@endpush
