<?php

use App\Models\Settings;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('access_token_zoho')->nullable()->default(null);
            //access_token_udpated_at
            $table->timestamp('access_token_updated_at')->nullable()->default(null);
        });

        //insert 1st entry
        $settings = new Settings();
        $settings->access_token_zoho = 'your_access_token_here';
        $settings->save();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
