<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Response;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Response::macro('success', function ($message, $data) {
            return response([
                'message' => $message,
                'error' => false,
                'response' => $data
            ], 200);
        });
        Response::macro('failed', function ($error) {
            return response([
                'error' => true,
                'message' => $error,
                'response' => NULL
            ], 200);
        });
    }
}
