<?php

namespace App\Mail\instaReels;

use App\Helpers\ProductsHelper;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderCancelledMail extends Mailable
{
    use Queueable, SerializesModels;

    public $transaction;
    private $product;

    public function __construct($transaction)
    {
        $this->transaction = $transaction;
        $this->product = ProductsHelper::getProduct($transaction->product_key);
    }

    public function build()
    {
        return $this->subject($this->transaction->user_name . ', Your Order Has Been Cancelled! ❌')
            ->view('insta-reels.sendMail')
            ->with([
                'user_name' => $this->transaction->user_name,
                'txn_id' => $this->transaction->client_txn_id,
                'user_mobile' => $this->transaction->user_mobile,
                'user_email' => $this->transaction->user_email,
                'price' => $this->product['price'],
                'name' => $this->product['product_name'],
                'domain' => $this->product['app_link'],
                //route reorder url
                'reorder_url' => url('/reorder/' . $this->transaction->user_mobile),
                'unsubscribe_url' => url('/unsubscribe/' . $this->transaction->user_mobile)
            ]);
    }
}
