<?php

namespace App\Mail\buddhaBundle;

use App\Helpers\ProductsHelper;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderConfirmationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $transaction;
    private $product;

    public function __construct($transaction)
    {
        $this->transaction = $transaction;
        $this->product = ProductsHelper::getProduct($transaction->product_key);
    }

    public function build()
    {
        return $this->subject('✅ Your Purchase Was Successful!')
            ->view('buddha-bundle.paymentSuccessMail')
            ->with([
                'product_name' => $this->product['product_name'],
                'user_name' => $this->transaction->user_name,
                'txn_id' => $this->transaction->client_txn_id,
                'txn_date' => $this->transaction->created_at->format('M d, Y'),
                'user_mobile' => $this->transaction->user_mobile,
                'user_email' => $this->transaction->user_email,
                'price' => $this->product['price'],
                'download_bundle' => "https://drive.google.com/drive/folders/1D-o4jtflG5H4KZ4kQExmKSb3OZnEYclJ",
                'free_bonus_1' => "https://drive.google.com/drive/folders/1PdIsyOdYFiU1ZJ5ggUKYDau2mGElUlTM",
                'all_links_pdf' => url('/download/' . $this->transaction->client_txn_id),
            ]);
    }
}
