<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Log;

class CaptureTrackingParams
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if ($request->has('gclid') && !empty($request->gclid)) {
            Log::info('gclid: ' . $request->gclid);
            Cookie::queue(cookie(
                'platform',
                'google',
                60 * 24 * 30,
                '/',
                null,
                false,
                false
            ));

            Cookie::queue(cookie(
                'gclid',
                $request->gclid,
                60 * 24 * 30,
                '/',
                null,
                false,
                false
            ));
        }

        // Check for fbclid parameter in the request
        if ($request->has('fbclid') && !empty($request->fbclid)) {
            Log::info('fbclid: ' . $request->fbclid);
            Cookie::queue(cookie(
                'platform',
                'meta',
                60 * 24 * 30,
                '/',
                null,
                false,
                false
            ));

            // Save fbclid cookie
            Cookie::queue(cookie(
                'fbclid',
                $request->fbclid,
                60 * 24 * 30,
                '/',
                null,
                false,
                false
            ));
        }

        return $next($request);
    }
}
