<?php

namespace App\Http\Controllers;

use App\Helpers\MetaHelper;
use App\Helpers\ProductsHelper;
use App\Mail\OrderCancelledMail;
use App\Mail\OrderConfirmationMail;
use App\Models\Settings;
use App\Models\Transaction;
use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\View;
use Twilio\Rest\Client as RestClient;

class WhatsAppController extends Controller
{

    public function reorder($txnId)
    {
        $logMessage = "Reorder WhatsApp clicked ID: " . $txnId . " at " . now()->format('Y-m-d H:i:s') . "\n"; // Log with timestamp

        // Append log to the file
        file_put_contents(public_path('reorder.txt'), $logMessage, FILE_APPEND);

        $transaction = Transaction::where('client_txn_id', $txnId)->first();
        if (!$transaction) {
            abort(404, 'Transaction not found');
        }
        $product = ProductsHelper::getProduct($transaction->product_key);
        $app_link = $product['app_link'];
        //redirect to app link
        return redirect($app_link);
    }



    public function test()
    {

        $transaction = Transaction::where('user_mobile', '8860554455')
            ->orderBy('id', 'desc')->first();

        if (!$transaction) {
            abort(404, 'TXN Not Found');
        }

        self::sendTemplateMessage('pending', $transaction->user_mobile, $transaction);

        return 'sending';
    }


    public static function sendTemplateMessage($type, $to, $transaction)
    {
        try {
            $product = ProductsHelper::getProduct($transaction->product_key);
            $to = 'whatsapp:+91' . $transaction->user_mobile;
            $twilioClient = new RestClient(env('TWILIO_ACCOUNT_SID'), env('TWILIO_AUTH_TOKEN'));

            if ($type == 'success') {
                $contentSid = 'HX8bfa9de129374f18fcc930fdc509c991';
                $contentVariables = json_encode([
                    "1" => $transaction->user_name,
                    "2" => $product['product_name'],
                    "3" => $product['app_link'],
                    "4" => $transaction->client_txn_id,
                    "5" => $transaction->user_mobile,
                    "6" => $transaction->user_email,
                    "7" => (string)$product['price'],
                    "8" => url('/order/' . ($transaction->client_txn_id)),
                    "9" => env('TELEGRAM_LINK')
                ], JSON_UNESCAPED_SLASHES);
            } elseif ($type == 'pending') {
                $contentSid = $product['cancel_whatsapp_twilio_content_sid'];
                $contentVariables = json_encode([
                    "1" => $transaction->user_name,
                    "2" => $product['product_name'],
                    "3" => $product['app_link'],
                    "4" => $transaction->client_txn_id,
                    "5" => $transaction->user_mobile,
                    "6" => $transaction->user_email,
                    "7" => (string)$product['price'],
                    "8" => url('/order-wp/' . ($transaction->client_txn_id))
                ], JSON_UNESCAPED_SLASHES);
            } else {
                Log::error('Invalid type ' . $type);
                return;
            }

            Log::info('variables ' . json_encode($contentVariables));

            $message = $twilioClient->messages->create($to, [
                'from' => env('TWILIO_WHATSAPP_FROM'),
                'contentSid' => $contentSid,
                'contentVariables' => $contentVariables,
            ]);

            Log::info('Message Sent ' . json_encode($message));
        } catch (\Throwable $th) {
            Log::error('Error sending whatsapp ' . $th->getMessage());
        }
    }

    public static function sendSucessWhatsapp($transaction)
    {
        self::sendTemplateMessage('success', $transaction->user_mobile, $transaction);
    }

    public function sendWhatsapp()
    {
        Log::info('Sending whatsapp to users after payment failure');
        $transactions = Transaction::where('status', 'pending')
            ->where('created_at', '<=', Carbon::now()->subMinutes(10))
            ->whereNull('first_whatsapp_sent_at')
            ->whereNotNull('user_mobile')
            ->get();

        foreach ($transactions as $transaction) {
            $this->sendTemplateMessage('pending', $transaction->user_mobile, $transaction);
            $transaction->first_whatsapp_sent_at = Carbon::now();
            $transaction->save();
        }

        return "Cancellation Whatsapp sent!";
    }

    public function sendReminderWhatsapp()
    {
        Log::info('Sending whatsapp whatsapp to users after payment failure');
        $transactions = Transaction::where('status', 'pending')
            ->where('created_at', '<=', Carbon::now()->subDay()->startOfDay()->addHours(9))
            ->whereNotNull('first_whatsapp_sent_at')
            ->whereNull('second_whatsapp_sent_at')
            ->whereNotNull('user_mobile')
            ->get();

        foreach ($transactions as $transaction) {
            $this->sendTemplateMessage('pending', $transaction->user_mobile, $transaction);
            $transaction->second_whatsapp_sent_at = Carbon::now();
            $transaction->save();
        }

        return "Reminder Whatsapp sent!";
    }

    public function serveOrderImage()
    {
        $path = public_path('assets/images/order.png');
        if (!file_exists($path)) {
            abort(404, 'Image not found');
        }
        $fileContent = file_get_contents($path);
        $headers = [
            'Content-Type' => 'image/png',
        ];
        return response($fileContent, 200, $headers);
    }
}
