<?php

namespace App\Http\Controllers;

use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use PhpParser\Node\Expr\FuncCall;
use Stringable;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ContentController extends Controller
{
    public function test()
    {

        return 'nothing!';
    }


    public function download()
    {
        // Products and types to fetch counts for
        $products = ['insta-reels', 'buddha-bundle', 'buddha-bundle-bg'];
        $types = ['success', 'pending'];
        $websites = ['start_digital', 'kharid_india'];

        // Initialize an array to store counts
        $counts = [];

        // Fetch counts for each product, type, and website
        foreach ($products as $product) {
            foreach ($types as $type) {
                // Total counts (for buttons)
                $counts[$product][$type]['total'] = Transaction::whereNotNull('user_email')
                    ->whereNotNull('user_mobile')
                    ->where('status', $type)
                    ->where('product_key', $product)
                    ->where('user_mobile', '!=', '8860554455')
                    ->where('user_mobile', '!=', '1234567890')
                    ->where('user_email', '!=', 'itsmetheofficial@gmail.com')
                    ->count();

                // Today's counts
                foreach ($websites as $website) {
                    $counts[$product][$type]['today'][$website] = Transaction::whereNotNull('user_email')
                        ->whereNotNull('user_mobile')
                        ->where('status', $type)
                        ->where('product_key', $product)
                        ->where('website', $website)
                        ->where('user_mobile', '!=', '8860554455')
                        ->where('user_mobile', '!=', '1234567890')
                        ->where('user_email', '!=', 'itsmetheofficial@gmail.com')
                        ->whereDate('created_at', today()) // Today's data
                        ->count();
                }

                // Yesterday's counts
                foreach ($websites as $website) {
                    $counts[$product][$type]['yesterday'][$website] = Transaction::whereNotNull('user_email')
                        ->whereNotNull('user_mobile')
                        ->where('status', $type)
                        ->where('product_key', $product)
                        ->where('website', $website)
                        ->where('user_mobile', '!=', '8860554455')
                        ->where('user_mobile', '!=', '1234567890')
                        ->where('user_email', '!=', 'itsmetheofficial@gmail.com')
                        ->whereDate('created_at', today()->subDay()) // Yesterday's data
                        ->count();
                }

                // Last 7 Days counts
                foreach ($websites as $website) {
                    $counts[$product][$type]['last_7_days'][$website] = Transaction::whereNotNull('user_email')
                        ->whereNotNull('user_mobile')
                        ->where('status', $type)
                        ->where('product_key', $product)
                        ->where('website', $website)
                        ->where('user_mobile', '!=', '8860554455')
                        ->where('user_mobile', '!=', '1234567890')
                        ->where('user_email', '!=', 'itsmetheofficial@gmail.com')
                        ->whereBetween('created_at', [now()->subDays(7), now()]) // Last 7 days
                        ->count();
                }
            }
        }
        // return $counts;

        // Pass counts to the view
        return view('download', compact('counts'));
    }

    public function viewTransactions($product_key)
    {

        // Fetch transactions based on status except specific email & mobile
        $transactions = Transaction::whereNotNull('user_email')
            ->whereNotNull('user_mobile')
            ->where('user_mobile', '!=', '8860554455')
            ->where('user_mobile', '!=', '1234567890')
            ->where('user_email', '!=', 'itsmetheofficial@gmail.com')
            // ->where('status', $status)
            ->where('product_key', $product_key)
            ->orderBy('created_at', 'desc') // Show latest records first
            ->paginate(30); // Paginate with 30 records per page

        return view('trans-list', compact('transactions'));
    }


    public function downloadCSV($type, $product_key)
    {

        // Query based on filter and exclude specific email & mobile
        $query = Transaction::whereNotNull('user_email')
            ->whereNotNull('user_mobile')
            ->where('status', $type)
            ->where('product_key', $product_key)
            ->where('user_mobile', '!=', '8860554455')
            ->where('user_mobile', '!=', '1234567890')
            ->where('user_email', '!=', 'itsmetheofficial@gmail.com');

        $transactions = $query->get();

        // Generate dynamic filename
        $fileName = "transactions_{$product_key}_{$type}_" . date('Y-m-d_H-i-s') . ".csv";

        $response = new StreamedResponse(function () use ($transactions) {
            $handle = fopen('php://output', 'w');

            // Write CSV Header
            // fputcsv($handle, ['First Name', 'Email', 'Phone']);
            fputcsv($handle, ['Email', 'Phone']);

            // Write Rows
            foreach ($transactions as $transaction) {
                fputcsv($handle, [
                    // $transaction->user_name,
                    $transaction->user_email,
                    "91" . $transaction->user_mobile
                ]);
            }

            fclose($handle);
        });

        $response->headers->set('Content-Type', 'text/csv');
        $response->headers->set('Content-Disposition', 'attachment; filename="' . $fileName . '"');

        return $response;
    }



    /**
     * Generate Random String
     */
    function generateRandomString($length = 10)
    {
        $characters = '0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }


    public function about()
    {
        return view('about');
    }

    public function privacy()
    {
        return view('privacy');
    }

    public function contact()
    {
        return view('contact');
    }

    public function terms()
    {
        return view('terms');
    }

    public function refund()
    {
        return view('refund');
    }

    public function shipping()
    {
        return view('shipping');
    }
}
