<?php

namespace App\Helpers;

use App\Http\Controllers\MailController;
use App\Http\Controllers\WhatsAppController;
use App\Mail\OrderConfirmationMail;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class ProductsHelper
{
    private static $products;
    private static $test_price = false; // Move test price here as class property

    public static function initializeProducts()
    {
        if (!self::$products) {
            self::$products = [
                'insta-reels' => [
                    'key' => 'insta-reels',
                    'meta_title' => 'Motion Graphic Reels for Insta Success -Start Digital',
                    'meta_description' => 'Motion Graphic Reels for Insta Success -Start Digital',
                    'download_file_link' => 'MOTION_REEL_BUNDLE_SPECIAL_PRIME_MEMBER.pdf',
                    'price' => self::$test_price ? 10 : 199,
                    'main_price' => "399",

                    'pixel_id' => "870624825103399",
                    'meta_access_token' => "EAAGmwXDpCFwBOZCgjp2oJ2Pba2kKmMFipSwMkI92g1dIqHZBU6mCHLxDFblJgd3v6nyvjVYS9vTlyRqWzskHaF9bIS4LxRdJqZCkjjMZCaOCZBfBYt7jvHXpeejSb3SVvaA3s0u3TZCPfJPn20N95JL8lkHY7UWnOKoZAfwPIEOnbYg6PBTd21XZAYaBw1D87wfr8AZDZD",

                    'conversion_id' => NULL,
                    'google_aw_id' => NULL,
                    'google_add_payment_info_event_id' => NULL,
                    'google_purchase_event_id' => NULL,
                    'google_purchase_conversion_label' => NULL,

                    'backend_test_id_meta' => 'TEST60667',
                    'product_name' => 'Motion Graphic Reels Bundle',
                    'mail_from_name' => 'Insta Reels Bundle -Support',
                    'cancel_whatsapp_twilio_content_sid' => 'HXfa5eaa713ebe8d1bf485f0d74c35896b',

                    'app_link' => url('/')
                ],
                'buddha-bundle' => [
                    'key' => 'buddha-bundle',
                    'meta_title' => 'Buddha Stories Bundle -Start Digital',
                    'meta_description' => 'Buddha Stories Bundle -Start Digital',
                    'download_file_link' => 'BUDDHA_STORIES_BUNDLE_SPECIAL_PRIME_MEMBER.pdf',
                    'price' => self::$test_price ? 11 : 399,
                    'main_price' => 599,

                    'pixel_id' => "1841086786296212",
                    'meta_access_token' => "EAAGmwXDpCFwBOwCkEvr2SisAPHkH5MJ3EulTLuXGPvkXcreOVlVZB1xCgJ8cLfx4QFY3FJTckHX0DcvZA59GZCP3JdoZBll3khTvN7WNHPu4tFXil8vQZAldnVH4WVwfckIJ4SUc662ZB1pQeetC7kNrz4XeKz0aoN738V8GMq4iA2ck6WPYGlxSuwIjVc8DwQUAZDZD",

                    'conversion_id' => '16876262696',
                    'google_aw_id' => 'AW-16876262696',
                    'google_add_payment_info_event_id' => 'AW-16876262696/wXOrCJi_2akaEKiqne8-',
                    'google_purchase_event_id' => 'AW-16876262696/3iS3CJu_2akaEKiqne8-',
                    'google_purchase_conversion_label' => '3iS3CJu_2akaEKiqne8-',

                    'backend_test_id_meta' => 'TEST59491',
                    'product_name' => '500+ Buddha Stories Bundle',
                    'mail_from_name' => 'Buddha Stories Bundle -Support',
                    // 'cancel_whatsapp_twilio_content_sid' => 'HXdff2229501de8349ec30f98e7a51835c',
                    'cancel_whatsapp_twilio_content_sid' => 'HXc4e1f9b46633fea1826812cb43bdc87e',

                    'app_link' => url('/buddha-bundle')

                ],
                'buddha-bundle-bg' => [
                    'key' => 'buddha-bundle-bg',
                    'meta_title' => 'Buddha Stories Bundle -Start Digital',
                    'meta_description' => 'Buddha Stories Bundle -Start Digital',
                    'download_file_link' => 'BUDDHA_STORIES_BUNDLE_SPECIAL_PRIME_MEMBER.pdf',
                    'price' => self::$test_price ? 11 : 399,
                    'main_price' => 599,

                    'pixel_id' => "2072795379900125",
                    'meta_access_token' => "EAAGmwXDpCFwBO47tV51ccl5rWe2Cd4Wj3ZCPdvsNjJJZBVJpBC41xEoVjZBaGNJdVEiiezrB5tfAuSUK2BpAwhAg3BIXpZCZBrpx4YhPkjeMamNQlm7TbzWtY7qycpZAbblMPzceV54o4WtT5URoDdCHZC9Tf1zTT6pK5UZC6ZA2fzaU6nVeMgfsxRaz6myhPXZCadeQZDZD",

                    'conversion_id' => '16876262696',
                    'google_aw_id' => 'AW-16876262696',
                    'google_add_payment_info_event_id' => 'AW-16876262696/wXOrCJi_2akaEKiqne8-',
                    'google_purchase_event_id' => 'AW-16876262696/3iS3CJu_2akaEKiqne8-',
                    'google_purchase_conversion_label' => '3iS3CJu_2akaEKiqne8-',

                    'backend_test_id_meta' => 'TEST91841',
                    'product_name' => '500+ Buddha Stories Bundle',
                    'mail_from_name' => 'Buddha Stories Bundle -Support',
                    // 'cancel_whatsapp_twilio_content_sid' => 'HXdff2229501de8349ec30f98e7a51835c',
                    'cancel_whatsapp_twilio_content_sid' => 'HX225e84a7f832e5c8bc71848839c56f37',

                    'app_link' => url('/buddha-bundle-bg')

                ],
            ];
        }
    }

    public static function getProduct($productKey)
    {
        self::initializeProducts();
        $product = self::$products[$productKey] ?? null;
        $productUrl = $product['app_link'] ?? env('APP_URL');

        // Generate URLs dynamically when accessed
        if ($product) {
            $product['app_link'] = url($productKey === 'insta-reels' ? '/' : $productUrl);
        }

        return $product;
    }

    public static function getAllProductKeys()
    {
        self::initializeProducts();
        return array_keys(self::$products);
    }

    public static function getProductTitle($productKey)
    {
        return ucwords(str_replace('-', ' ', $productKey));
    }
}
