<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();
        // Send the first email after 5 minutes of payment failure
        // $schedule->call(function () {
        //     app(\App\Http\Controllers\MailController::class)->sendMail();
        // })->everyFiveMinutes();

        // Send the second email at 9 AM the next day
        // $schedule->call(function () {
        //     app(\App\Http\Controllers\MailController::class)->sendReminderMail();
        // })->dailyAt('19:30');

        //send the first whatsapp message after 5 minutes of payment failure
        $schedule->call(function () {
            app(\App\Http\Controllers\WhatsAppController::class)->sendWhatsapp();
        })->everyFiveMinutes();

        // $schedule->call(function () {
        //     app(\App\Http\Controllers\WhatsAppController::class)->sendWhatsapp();
        // })->everyMinute();

        //send the second whatsapp message at 9 AM the next day
        $schedule->call(function () {
            app(\App\Http\Controllers\WhatsAppController::class)->sendReminderWhatsapp();
        })->dailyAt('19:30');
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
